IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[P_EST_WMS_SAI_RET_EST_PED_VD_PEND_PROCESSAR]') 
					AND type in (N'P', N'PC'))
BEGIN
	DROP PROCEDURE [DBO].[P_EST_WMS_SAI_RET_EST_PED_VD_PEND_PROCESSAR]
END
GO
--P_EST_WMS_SAI_RET_EST_PED_VD_PEND_PROCESSAR 519520
/*
***********************************************************************
	Este job esta sendo executado pela procedure P_INCLUI_PENDENCIA_WMS
***********************************************************************
*/
CREATE PROCEDURE P_EST_WMS_SAI_RET_EST_PED_VD_PEND_PROCESSAR @CD_PED_WMS_PAR INT=0 AS
DECLARE @CD_EMP INT
DECLARE @CD_FILIAL INT
DECLARE @CD_PED INT
DECLARE @CD_PED_WMS INT
DECLARE @CD_CONTROLE INT
DECLARE @CD_USU INT

SET NOCOUNT ON;
PRINT 'Inicio da rotina - Hora : '+ CONVERT(VARCHAR, GETDATE(),108);
DECLARE ProcWMSPed CURSOR FAST_FORWARD
FOR SELECT
		PEND.CD_PED_WMS, 
		PED.CD_EMP,
		PED.CD_FILIAL,
		PED.CD_PED,
		1
	FROM
		EST_WMS_SAI_RET_PEND PEND INNER JOIN EST_PED_VD_EST_WMS_SAI PED ON
		PEND.CD_PED_WMS = PED.CD_PED_WMS
		INNER JOIN EST_PED_VD ON
		PED.CD_EMP = EST_PED_VD.CD_EMP AND 
		PED.CD_FILIAL = EST_PED_VD.CD_FILIAL AND 
		PED.CD_PED = EST_PED_VD.CD_PED  
	WHERE
		PEND.CD_PED_WMS= CASE WHEN @CD_PED_WMS_PAR=0 THEN  PEND.CD_PED_WMS ELSE @CD_PED_WMS_PAR END 

OPEN ProcWMSPed;
FETCH NEXT FROM ProcWMSPed INTO @CD_PED_WMS,
								@CD_EMP,
								@CD_FILIAL,
								@CD_PED,
								@CD_USU;
WHILE @@FETCH_STATUS = 0
	BEGIN
		PRINT 'Gerando controle checkOut cabecalho - Hora : '+ CONVERT(VARCHAR, GETDATE(),108);
		INSERT INTO EST_PED_VD_CONF
		(CD_EMP,
		CD_FILIAL,
		CD_PED,
		CD_USU,
		DT_CAD,
		DT_REF)
		SELECT
			@CD_EMP,
			@CD_FILIAL,
			@CD_PED,
			1,
			CONVERT(CHAR(10),GETDATE(),112),
			GETDATE()

		PRINT 'Gravancado itens do controle de fases - Hora : '+ CONVERT(VARCHAR, GETDATE(),108);
		--Controle do CheckOut dA EST_PED_VD
		INSERT INTO EST_PED_VD_CONF_CPL
		(CD_EMP,
		CD_FILIAL,
		CD_PED,
		CD_PROD,
		QT_IT_CHECK)
		SELECT
			PED.CD_EMP,
			PED.CD_FILIAL,
			PED.CD_PED,
			RET.CD_PROD,
			SUM(RET.QT_PROD) AS QT_PROD
		FROM
			EST_WMS_SAI_RET RET INNER JOIN EST_PED_VD_EST_WMS_SAI PED ON
			RET.CD_PED_WMS = PED.CD_PED_WMS
		WHERE
			RET.QT_PROD >0
			AND RET.CD_PED_WMS = @CD_PED_WMS
		GROUP BY 
			PED.CD_EMP,
			PED.CD_FILIAL,
			PED.CD_PED,
			RET.CD_PROD
		PRINT 'Zerando itens do ressuprimento - Hora : '+ CONVERT(VARCHAR, GETDATE(),108);
	  --Zerando quantidade atendida do ressuprimento
	  UPDATE
		EST_PED_VD_IT
	  SET 
		EST_PED_VD_IT.QT_SOL=EST_PED_VD_IT.QT_IT,
		EST_PED_VD_IT.QT_IT=0
	 WHERE
		EST_PED_VD_IT.CD_EMP=@CD_EMP
		AND EST_PED_VD_IT.CD_FILIAL = @CD_FILIAL
		AND EST_PED_VD_IT.CD_PED=@CD_PED
		
		PRINT 'Gravando quantidade itens atendido do ressuprimento - Hora : '+ CONVERT(VARCHAR, GETDATE(),108);
	  --Quantidade atendida do ressuprimento
	  UPDATE
		IT
	  SET 
		IT.QT_IT=EST_PED_VD_CONF_CPL.QT_IT_CHECK
	  FROM
		 EST_PED_VD_IT IT INNER JOIN EST_PED_VD_CONF_CPL ON
		 IT.CD_EMP = EST_PED_VD_CONF_CPL.CD_EMP AND
		 IT.CD_FILIAL = EST_PED_VD_CONF_CPL.CD_FILIAL AND
		 IT.CD_PED = EST_PED_VD_CONF_CPL.CD_PED AND
		 IT.CD_PROD = EST_PED_VD_CONF_CPL.CD_PROD 
	  WHERE
		IT.CD_EMP=@CD_EMP
		AND IT.CD_FILIAL=@CD_FILIAL
		AND IT.CD_PED=@CD_PED

	  PRINT 'Mudando status do ressuprimento - Hora : '+ CONVERT(VARCHAR, GETDATE(),108);
	  --Mudando status do ressuprimento para checkout finalizado
	  UPDATE
		EST_PED_VD_PENDENCIA
	  SET 
		FLAG_REALIZAR_FAT=1
	 WHERE
		CD_EMP=@CD_EMP
		AND CD_FILIAL = @CD_FILIAL
		AND CD_PED=@CD_PED

	PRINT 'Deletando pendencias de retorno - Hora : '+ CONVERT(VARCHAR, GETDATE(),108);
	DELETE FROM EST_WMS_SAI_RET_PEND WHERE CD_PED_WMS = @CD_PED_WMS 

FETCH NEXT FROM ProcWMSPed INTO @CD_PED_WMS,
								@CD_EMP,
								@CD_FILIAL,
								@CD_PED,
								@CD_USU;
END;
PRINT 'Concluido.';
CLOSE ProcWMSPed;
DEALLOCATE ProcWMSPed;